<?php
/**
 * Class that operate on table 'lastbillidsquickprofit'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-03-29 05:49
 */
class LastbillidsquickprofitMySqlDAO implements LastbillidsquickprofitDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return LastbillidsquickprofitMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM lastbillidsquickprofit WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM lastbillidsquickprofit';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM lastbillidsquickprofit ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param lastbillidsquickprofit primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM lastbillidsquickprofit WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param LastbillidsquickprofitMySql lastbillidsquickprofit
 	 */
	public function insert($lastbillidsquickprofit){
		$sql = 'INSERT INTO lastbillidsquickprofit (sell, sellDetail, sellandret, sellandretDetail, retsell, retsellDetail) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($lastbillidsquickprofit->sell);
		$sqlQuery->setNumber($lastbillidsquickprofit->sellDetail);
		$sqlQuery->setNumber($lastbillidsquickprofit->sellandret);
		$sqlQuery->setNumber($lastbillidsquickprofit->sellandretDetail);
		$sqlQuery->setNumber($lastbillidsquickprofit->retsell);
		$sqlQuery->setNumber($lastbillidsquickprofit->retsellDetail);

		$id = $this->executeInsert($sqlQuery);	
		$lastbillidsquickprofit->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param LastbillidsquickprofitMySql lastbillidsquickprofit
 	 */
	public function update($lastbillidsquickprofit){
		$sql = 'UPDATE lastbillidsquickprofit SET sell = ?, sellDetail = ?, sellandret = ?, sellandretDetail = ?, retsell = ?, retsellDetail = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($lastbillidsquickprofit->sell);
		$sqlQuery->setNumber($lastbillidsquickprofit->sellDetail);
		$sqlQuery->setNumber($lastbillidsquickprofit->sellandret);
		$sqlQuery->setNumber($lastbillidsquickprofit->sellandretDetail);
		$sqlQuery->setNumber($lastbillidsquickprofit->retsell);
		$sqlQuery->setNumber($lastbillidsquickprofit->retsellDetail);

		$sqlQuery->setNumber($lastbillidsquickprofit->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM lastbillidsquickprofit';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySell($value){
		$sql = 'SELECT * FROM lastbillidsquickprofit WHERE sell = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellDetail($value){
		$sql = 'SELECT * FROM lastbillidsquickprofit WHERE sellDetail = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellandret($value){
		$sql = 'SELECT * FROM lastbillidsquickprofit WHERE sellandret = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellandretDetail($value){
		$sql = 'SELECT * FROM lastbillidsquickprofit WHERE sellandretDetail = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRetsell($value){
		$sql = 'SELECT * FROM lastbillidsquickprofit WHERE retsell = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRetsellDetail($value){
		$sql = 'SELECT * FROM lastbillidsquickprofit WHERE retsellDetail = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySell($value){
		$sql = 'DELETE FROM lastbillidsquickprofit WHERE sell = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellDetail($value){
		$sql = 'DELETE FROM lastbillidsquickprofit WHERE sellDetail = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellandret($value){
		$sql = 'DELETE FROM lastbillidsquickprofit WHERE sellandret = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellandretDetail($value){
		$sql = 'DELETE FROM lastbillidsquickprofit WHERE sellandretDetail = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRetsell($value){
		$sql = 'DELETE FROM lastbillidsquickprofit WHERE retsell = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRetsellDetail($value){
		$sql = 'DELETE FROM lastbillidsquickprofit WHERE retsellDetail = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return LastbillidsquickprofitMySql 
	 */
	protected function readRow($row){
		$lastbillidsquickprofit = new Lastbillidsquickprofit();
		
		$lastbillidsquickprofit->id = $row['id'];
		$lastbillidsquickprofit->sell = $row['sell'];
		$lastbillidsquickprofit->sellDetail = $row['sellDetail'];
		$lastbillidsquickprofit->sellandret = $row['sellandret'];
		$lastbillidsquickprofit->sellandretDetail = $row['sellandretDetail'];
		$lastbillidsquickprofit->retsell = $row['retsell'];
		$lastbillidsquickprofit->retsellDetail = $row['retsellDetail'];

		return $lastbillidsquickprofit;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return LastbillidsquickprofitMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>